function cdx_new = merge_CDX_covariates(CDX, covariate_data)
% --------------------------------------------------------------------------------------------------
% Merge CDX data (tranche and cds prices) with firm-specific covariate time series. In addition, add
% time-series of instananeous default intensity implied by the model in Duffie, Eckner, Horel and
% Saita (2006).
% --------------------------------------------------------------------------------------------------
% CDX                           ... credit index structure (see 'all_steps_in_a_row.m')
% covariate_data                ... data from compustat with debt levels, market_cap, ...
% --------------------------------------------------------------------------------------------------
% sample call: merge_CDX_covariates(CDX_NA_IG, data_compustat)
% --------------------------------------------------------------------------------------------------

% Only merge data if covariate time series is available
covariate_tickers = {covariate_data.ticker};
% % Replace ticker 'FD' with 'M'
% macys_pos = find(strcmp(covariate_tickers, 'FD'));
% covariate_tickers{macys_pos} = 'M';
for i=1:length(CDX.portfolio)
    % Determine matching covariates
    cds = CDX.portfolio(i);
    covariate_pos = find(strcmp(cds.ticker, covariate_tickers));
    
    % If no covariate data available at all, just create empty fields
    if (isempty(covariate_pos))
        cds.debt = [];
        cds.mcap = [];
        cds.share_price = [];
        cds.intensity_P = [];
    else
        covariates = covariate_data(covariate_pos);

        % Determine dates with available covariate data
        [trash, ai, bi] = intersect(cds.dates{1}, covariates.dates);
        if (isempty(ai))
            cds.debt = [];
            cds.mcap = [];
            cds.share_price = [];
            cds.intensity_P = [];
        else
            % Interpolate positions for dates where no covariates available
            used_covariate_pos = interpolate_pos(ai, bi, length(cds.dates{1}));
            cds.debt = covariates.st_debt(used_covariate_pos) + 1/2 * covariates.st_debt(used_covariate_pos);
            cds.mcap = covariates.mcap(used_covariate_pos);
            cds.share_price = covariates.share_price(used_covariate_pos);

            % Set default intensity equal to 0.01
            cds.intensity_P =  ones(length(cds.debt), 1)*0.01; 
        end
    end
    
    % Insert CDS into portfolio
    if (i==1)
        portfolio = cds;
    else
        portfolio(i) = cds;
    end
end
CDX.portfolio = portfolio;
cdx_new = CDX;
